/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

 /**
 * \file    uart_loopback_test.c
 *
 * \brief   This file contains support routines to test uart. 
 *
 * This file contains support routines to test uart 
 * 
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

#include "uart.h"
#include "stdio.h"
/** **************************************************************************
 * \n \brief Routine receive a byte of data from uart.
 *
 * This routine receive a byte of data from uart.This routine takes uart id  as 
 * a parameter which gives information about which uart to be selected along with 
 * that it takes bufferpointer as another parameter to copy the received data 
 * and timeout as another parameter.
 *
 * \param   uart		 [IN]     uart to be selected
 * \param   *rx          [IN]     Buffer pointer to copy received data 
 * \param   timeout      [IN]     Timeout for receiving  
 *                                                                
 * \return        
 * \n        returns 1 on failure                                        
 * \n        returns 0 on success
 *  
 * 
 */
INT16 uart_recv( UART_Handle uart, UINT8* rx, INT32 timeout )
{
    /* Check if RX ready, if not timeout */
    while( _UART_rcvReady( uart ) == 0 )
    {
    	
          if ( timeout-- < 0 )
          {
              printf("Timeout occured while Receiving\n");
              return 1;
          }    
    }        

    /* Read 1 byte */
    _UART_getChar( uart, rx );
    return 0;
}
/** **************************************************************************
 * \n \brief Routine send a byte of data to uart.
 *
 * This routine send a byte of data to uart.This routine takes uart id as 
 * a parameter which gives information about which uart to be selected along with 
 * that it takes buffer pointer as another parameter to send  data 
 * and timeout as another parameter.
 *
 * \param   uart	    [IN]    uart to be selected
 * \param   tx          [IN]    Data to be transmitted 
 * \param   timeout     [IN]    Timeout for transmitting
 *                                                                
 * \return        
 * \n        returns 1 on failure                                        
 * \n        returns 0 on success
 *  
 * 
 */
INT16 uart_send( UART_Handle uart, UINT8 tx, INT32 timeout )
{
    /* Check if TX ready, if not timeout */
    while( _UART_xmtReady( uart ) == 0 )
    {
    	
        if ( timeout-- < 0 )
        {
           printf("Timeout occured while transmitting\n");
           return 1;
        }   
    }        
            
    /* Write 1 byte */
   _UART_putChar( uart, tx );
    
    return 0;    
}

 /** **************************************************************************
 * \n \brief Routine to do uart_loopback_test
 *
 * This routine does uart_loopback_test.This routine transmits a buffer of size  
 * 256 bytes and receives the same and compares both the buffer .Returns 0 on
 * success.
 * 
 * \return        
 * \n        returns Non-Zero value on failure                                        
 * \n        returns zero success
 *  
 * 
 */

INT16 uart_Echo_test( )
{
  
static UINT8 rx = 0; 
static INT32 uart_timeout = ( 0x00080000 );
 UART_Handle uart2;
 
    /* Open Uart Handle */
    if ( ( uart2 = _UART_open( UART_0, /*115200*/ 26 ) ) == 0 )
        return -1;

        
    /* UART Test */
	while(1)
	{ 
	   printf("Enter a character in the hyperterminal\n");
       
        while((uart_recv( uart2, &rx, uart_timeout ))!=0);//RX
	    
	    if( uart_send( uart2, rx, uart_timeout ))   // TX
            return 1;
            
        printf("check you have received same character in hyperterminal\n");
       
    }
   
 

}
